/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.config.ASMConfiguration;
import gtPlusPlus.core.item.base.dusts.BaseItemDustUnique;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenDustGeneration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    private static final Map<Item, String> mModidCache = new HashMap<Item, String>();

    public static ItemStack getItemStackOfAmountFromOreDict(String oredictName, int amount) {
        String mTemp = oredictName;
        mTemp = oredictName.contains("-") || oredictName.contains("_") ? StringUtils.sanitizeStringKeepDashes(mTemp) : StringUtils.sanitizeString(mTemp);
        if (oredictName.contains("rod")) {
            oredictName = "stick" + oredictName.substring(3);
        }
        if (oredictName.toLowerCase().contains("ingotclay")) {
            return new ItemStack(Items.field_151119_aD, amount);
        }
        ArrayList oreDictList = OreDictionary.getOres((String)mTemp);
        if (!oreDictList.isEmpty()) {
            ItemStack returnValue = ((ItemStack)oreDictList.get(0)).func_77946_l();
            returnValue.field_77994_a = amount;
            return returnValue;
        }
        Logger.INFO("Failed to find `" + oredictName + "` in OD.");
        return null;
    }

    public static ItemStack getItemStackOfAmountFromOreDictNoBroken(String oredictName, int amount) {
        if (ASMConfiguration.debug.debugMode) {
            Logger.modLogger.warn("Looking up: " + oredictName + " - from : ", (Throwable)new Exception());
        }
        try {
            String MaterialName;
            Materials m;
            oredictName = oredictName.contains("-") || oredictName.contains("_") ? StringUtils.sanitizeStringKeepDashes(oredictName) : StringUtils.sanitizeString(oredictName);
            ItemStack returnValue = null;
            if (oredictName.toLowerCase().contains("dust") && (m = Materials.get(MaterialName = oredictName.toLowerCase().replace("dust", ""))) != Materials._NULL && (returnValue = GTOreDictUnificator.get(OrePrefixes.dust, m, 1L)) != null) {
                return returnValue;
            }
            if (returnValue == null && (returnValue = ItemUtils.getItemStackOfAmountFromOreDict(oredictName, amount)) != null) {
                return returnValue.func_77946_l();
            }
            Logger.RECIPE(oredictName + " was not valid.");
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Item[] generateSpecialUseDusts(String unlocalizedName, String materialName, int Colour) {
        return ItemUtils.generateSpecialUseDusts(unlocalizedName, materialName, "NullFormula", Colour);
    }

    public static Item[] generateSpecialUseDusts(String unlocalizedName, String materialName, String mChemForm, int Colour) {
        GTLanguageManager.addStringLocalization("gtplusplus.material." + materialName, materialName);
        Item[] output = new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, mChemForm, Colour, "Dust"), new BaseItemDustUnique("itemDustSmall" + unlocalizedName, materialName, mChemForm, Colour, "Small"), new BaseItemDustUnique("itemDustTiny" + unlocalizedName, materialName, mChemForm, Colour, "Tiny")};
        ItemStack normalDust = new ItemStack(output[0]);
        ItemStack smallDust = new ItemStack(output[1]);
        ItemStack tinyDust = new ItemStack(output[2]);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, smallDust), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(normalDust).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, tinyDust), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(normalDust).duration(100).eut(4).addTo(RecipeMaps.packagerRecipes);
        if (tinyDust != null && normalDust != null) {
            if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
                Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + materialName + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, GTUtility.copyAmount(9, tinyDust))) {
                Logger.WARNING("9 Tiny dust from 1 Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("9 Tiny dust from 1 Recipe: " + materialName + " - Failed");
            }
        }
        if (smallDust != null && normalDust != null) {
            if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
                Logger.WARNING("4 Small dust to 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("4 Small dust to 1 Dust Recipe: " + materialName + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, GTUtility.copyAmount(4, smallDust))) {
                Logger.WARNING("4 Small dust from 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("4 Small dust from 1 Dust Recipe: " + materialName + " - Failed");
            }
        }
        return output;
    }

    public static Item[] generateSpecialUseDusts(Material material, boolean onlyLargeDust) {
        return ItemUtils.generateSpecialUseDusts(material, onlyLargeDust, false);
    }

    public static Item[] generateSpecialUseDusts(Material material, boolean onlyLargeDust, boolean disableExtraRecipes) {
        String materialName = material.getUnlocalizedName();
        String unlocalizedName = StringUtils.sanitizeString(materialName);
        int Colour = material.getRgbAsHex();
        String aChemForm = material.vChemicalFormula;
        boolean isChemFormvalid = aChemForm != null && !aChemForm.isEmpty();
        Item[] output = null;
        output = !onlyLargeDust ? new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Dust"), new BaseItemDustUnique("itemDustSmall" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Small"), new BaseItemDustUnique("itemDustTiny" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Tiny")} : new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, Colour, "Dust")};
        new RecipeGenDustGeneration(material, disableExtraRecipes);
        return output;
    }

    public static int getRadioactivityLevel(String materialName) {
        int sRadiation = 0;
        if (materialName.toLowerCase().contains("uranium")) {
            sRadiation = 2;
        } else if (materialName.toLowerCase().contains("plutonium")) {
            sRadiation = 4;
        } else if (materialName.toLowerCase().contains("thorium")) {
            sRadiation = 1;
        }
        return sRadiation;
    }

    public static String getArrayStackNames(FluidStack[] aStack) {
        String itemNames = "Fluid Array: ";
        for (FluidStack alph : aStack) {
            String temp;
            if (alph != null) {
                temp = itemNames;
                itemNames = temp + ", " + alph.getLocalizedName() + " x" + alph.amount;
                continue;
            }
            temp = itemNames;
            itemNames = temp + ", null x0";
        }
        return itemNames;
    }

    public static String getArrayStackNames(ItemStack[] aStack) {
        String itemNames = "";
        int aPos = 0;
        for (ItemStack alph : aStack) {
            if (alph == null) continue;
            String temp = itemNames;
            itemNames = temp + (aPos > 0 ? ", " : "") + alph.func_82833_r() + " x" + alph.field_77994_a;
            ++aPos;
        }
        return itemNames;
    }

    private static String getModId(Item item) {
        if (mModidCache.containsKey(item)) {
            return mModidCache.get(item);
        }
        String value = "";
        try {
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)item);
            if (id != null) {
                String modname = id.modId == null ? id.name : id.modId;
                value = id.modId.isEmpty() ? Mods.Minecraft.ID : modname;
            }
        }
        catch (Throwable t) {
            try {
                GameRegistry.UniqueIdentifier t2 = GameRegistry.findUniqueIdentifierFor((Block)Block.func_149634_a((Item)item));
                if (t2 != null) {
                    String modname = t2.modId == null ? t2.name : t2.modId;
                    value = t2.modId.isEmpty() ? Mods.Minecraft.ID : modname;
                }
            }
            catch (Throwable t3) {
                t3.printStackTrace();
                value = "bad modid";
            }
        }
        if (!mModidCache.containsKey(item)) {
            return mModidCache.put(item, value);
        }
        return value;
    }

    public static String getModId(ItemStack key) {
        return ItemUtils.getModId(key.func_77973_b());
    }

    public static ItemStack getGregtechDust(String oredictName, int amount) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            for (ItemStack itemStack : oreDictList) {
                String modid = ItemUtils.getModId(itemStack.func_77973_b());
                if (modid == null || !modid.equals(Mods.GregTech.ID) && !modid.equals(Mods.GTPlusPlus.ID)) continue;
                ItemStack returnvalue = itemStack.func_77946_l();
                returnvalue.field_77994_a = amount;
                return returnvalue;
            }
        }
        return ItemUtils.getNonTinkersDust(oredictName, amount);
    }

    public static ItemStack getNonTinkersDust(String oredictName, int amount) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            for (ItemStack itemStack : oreDictList) {
                String modid = ItemUtils.getModId(itemStack.func_77973_b());
                if (modid == null || modid.equals("tconstruct")) continue;
                ItemStack returnvalue = itemStack.func_77946_l();
                returnvalue.field_77994_a = amount;
                return returnvalue;
            }
        }
        return ItemUtils.getItemStackOfAmountFromOreDictNoBroken(oredictName, amount);
    }

    public static ItemStack getOrePrefixStack(OrePrefixes mPrefix, Material mMat, int mAmount) {
        String mName = StringUtils.sanitizeString(mMat.getLocalizedName());
        String mItemName = mPrefix.name() + mName;
        return ItemUtils.getItemStackOfAmountFromOreDictNoBroken(mItemName, mAmount);
    }

    public static ItemStack getOrePrefixStack(OrePrefixes mPrefix, Materials mMat, int mAmount) {
        ItemStack aGtStack;
        if (mPrefix == OrePrefixes.rod) {
            mPrefix = OrePrefixes.stick;
        }
        if ((aGtStack = GTOreDictUnificator.get(mPrefix, mMat, (long)mAmount)) == null) {
            Logger.INFO("Failed to find `" + (Object)((Object)mPrefix) + MaterialUtils.getMaterialName(mMat) + "` in OD. [Prefix Search]");
        }
        return aGtStack;
    }

    public static boolean checkForInvalidItems(ItemStack[] mInput) {
        if (mInput == null) {
            return false;
        }
        for (ItemStack stack : mInput) {
            if (stack != null) continue;
            return false;
        }
        return true;
    }

    public static IInventory organiseInventory(IInventory aInputInventory) {
        ItemStack[] p = new ItemStack[aInputInventory.func_70302_i_()];
        for (int o = 0; o < aInputInventory.func_70302_i_(); ++o) {
            p[o] = aInputInventory.func_70301_a(o);
        }
        for (int i = 0; i < p.length; ++i) {
            for (int j = i + 1; j < p.length; ++j) {
                if (p[j] == null || p[i] != null && !GTUtility.areStacksEqual(p[i], p[j])) continue;
                GTUtility.moveStackFromSlotAToSlotB(aInputInventory, aInputInventory, j, i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
        return aInputInventory;
    }

    public static String getFluidName(FluidStack aFluid) {
        return aFluid != null ? aFluid.getFluid().getLocalizedName(aFluid) : "NULL";
    }

    public static String getItemName(ItemStack aStack) {
        if (aStack == null) {
            return "ERROR - Empty Stack";
        }
        String aDisplay = null;
        try {
            NBTTagCompound nbttagcompound;
            aDisplay = StatCollector.func_74838_a((String)(aStack.func_77973_b().func_77657_g(aStack) + ".name")).trim();
            if (aStack.func_77942_o() && aStack.field_77990_d != null && aStack.field_77990_d.func_150297_b("display", 10) && (nbttagcompound = aStack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
                aDisplay = nbttagcompound.func_74779_i("Name");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        aDisplay = aDisplay == null || aDisplay.length() == 0 ? aStack.func_77977_a() + ":" + aStack.func_77960_j() : aDisplay + " | Meta: " + aStack.func_77960_j();
        return aDisplay;
    }

    public static ItemStack[] cleanItemStackArray(ItemStack[] input) {
        int aArraySize = input.length;
        ItemStack[] aOutput = new ItemStack[aArraySize];
        ArrayList<ItemStack> aCleanedItems = new ArrayList<ItemStack>();
        for (ItemStack checkStack : input) {
            if (checkStack == null) continue;
            aCleanedItems.add(checkStack);
        }
        for (int i = 0; i < aCleanedItems.size(); ++i) {
            ItemStack aMappedStack = (ItemStack)aCleanedItems.get(i);
            if (aMappedStack == null) continue;
            aOutput[i] = aMappedStack;
        }
        return aOutput;
    }

    public static ItemStack depleteStack(ItemStack aStack, int aAmount) {
        int cap = aStack.field_77994_a;
        if (cap >= 1 && cap >= aAmount) {
            ItemStack aDepStack = aStack.func_77946_l();
            aDepStack.field_77994_a = MathUtils.balance(aDepStack.field_77994_a - 1, 0, 64);
            if (aDepStack.field_77994_a > 0) {
                return aDepStack;
            }
        }
        return null;
    }
}

